/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.sdgraph.SdgCrNode;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgEsaNode;
import cz.insophy.inplan.sdgraph.SdgGarNode;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.SdgMatprodNode;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.SdgSrNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraphImpl;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public interface StoreDependencyGraph {
    public static final Material INTER_GAR_MATERIAL = StoreDependencyGraphImpl.InterGarMaterial.INSTANCE;

    @Nonnull
    public Superplan getSuperplan();

    @Nonnull
    public Collection<SdgNode> getAllNodes();

    @Nonnull
    public List<SdgEdge> getAllEdges();

    default public <T extends SdgNode> Collection<T> getNodes(Class<T> type) {
        Preconditions.checkArgument(SdgNode.class.isAssignableFrom(type), "%s is not a subclass of SdgNode.", (Object)type.getSimpleName());
        return Sets.newHashSet(Iterables.filter(this.getAllNodes(), type));
    }

    @Nonnull
    public SdgSrNode getNode(@Nonnull SupplyRequest var1) throws IllegalArgumentException;

    @Nonnull
    public SdgEsaNode getNode(@Nonnull ExternalStoreActivity var1) throws IllegalArgumentException;

    @Nonnull
    public SdgGorNode getNode(@Nonnull GeneralizedOrderRequest var1) throws IllegalArgumentException;

    @Nonnull
    public SdgGarNode getNode(@Nonnull GeneralizedActionRequest var1) throws IllegalArgumentException;

    @Nonnull
    public SdgCrNode getNode(@Nonnull CustomerRequest var1) throws IllegalArgumentException;

    @Nonnull
    public SdgMatprodNode getNode(@Nonnull Material var1) throws IllegalArgumentException;

    public List<NodeLevel> topologicallySortNodes(Collection<SdgNode> var1, Direction var2);

    public static class NodeLevel {
        private final SdgNode node;
        private final int level;

        NodeLevel(SdgNode node, int level) {
            this.node = node;
            this.level = level;
        }

        public SdgNode getNode() {
            return this.node;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return "NodeLevel{node=" + this.node + ", level=" + this.level + "}";
        }
    }

    public static enum Direction {
        TO_SOURCES,
        TO_FINALS;

    }
}

